# 画面設計書 25-Wasm HotReload Test

## 概要

本ドキュメントは、WebAssembly ホットリロード機能テスト画面（index.html）の画面設計書です。.NET WebAssembly 環境における MetadataUpdater を使用した実行時コード更新機能をテストするための HTML/JavaScript ページとして実装されています。

### 本画面の処理概要

この画面は、.NET WebAssembly 環境でホットリロード（実行時コード更新）機能が正しく動作することを検証するためのテストページです。JavaScript から .NET メソッドを呼び出し、アセンブリのメタデータ更新を通じてコードが動的に変更されることを確認します。

**業務上の目的・背景**：本画面は .NET Runtime の機能テストとして、WebAssembly 環境における `System.Reflection.Metadata.MetadataUpdater.ApplyUpdate()` API が正しく機能することを検証するために存在します。開発時のホットリロード機能は、コード変更後にアプリケーションを再起動せずに変更を反映できるため、開発効率を大幅に向上させます。このテストは、その基盤となる API が WebAssembly 環境で動作することを確認します。

**画面へのアクセス方法**：WebAssembly アプリケーションをビルド・起動後、ブラウザで index.html にアクセスすることで本画面が表示されます。

**主要な操作・処理内容**：
1. ページ読み込み時に .NET WebAssembly ランタイムを初期化
2. `DOTNET_MODIFIABLE_ASSEMBLIES` 環境変数を "debug" に設定
3. JavaScript から .NET の `TestMeaning()` メソッドを呼び出し
4. `TestMeaning()` 内で MetadataUpdater の機能を検証
5. アセンブリを更新し、メソッドの戻り値が変化することを確認
6. テスト結果（42: 成功、1: 失敗）を画面とコンソールに出力

**画面遷移**：本画面は単独で動作するテストページであり、他の画面への遷移機能はありません。

**権限による表示制御**：本画面は認証・認可による表示制御を実装していません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Mono | 主機能 | WebAssemblyホットリロード機能のテスト実行 |
| 59 | WebAssembly Workload | 主機能 | WebAssemblyアプリケーションのビルドと実行をサポート |
| 24 | System.Reflection.Emit | 主機能 | ホットリロードによる実行時コード更新テスト |

## 画面種別

機能テストページ / ホットリロードテスト

## URL/ルーティング

- **URL**: `/index.html`（静的 HTML ファイル）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| ret | 出力 | int | - | テスト結果コード（42: 成功、1 以外: 失敗） |

## 表示項目

| 項目名 | 表示形式 | データソース | 説明 |
|--------|----------|--------------|------|
| ページタイトル | title | 固定値 | "Wasm HotReload Test" |
| ヘッダー | h3 | 固定値 | "Wasm HotReload Test" |
| 結果表示プレフィックス | テキスト | 固定値 | "Answer to the Ultimate Question of Life, the Universe, and Everything is :" |
| テスト結果 | span#out | ret 変数 | テスト結果の数値（正常時: 42） |
| テスト完了フラグ | label#tests_done | exit_code | テスト完了時に動的に追加される要素 |

## イベント仕様

### 1-ページ読み込み時処理

**トリガー**: ページの読み込み完了時（main.js の実行）

**処理フロー**:
1. `dotnet.js` モジュールをインポート
2. `withConfig({ appendElementOnExit: true })` で終了時要素追加を設定
3. `withEnvironmentVariable("DOTNET_MODIFIABLE_ASSEMBLIES", "debug")` でホットリロード有効化
4. `.create()` で .NET ランタイムを初期化
5. `getAssemblyExports()` でアセンブリのエクスポートを取得
6. `TestMeaning()` メソッドを呼び出し
7. 結果を `#out` 要素に表示
8. `wasm_exit()` を呼び出してテスト完了を通知

### 2-TestMeaning メソッド実行

**トリガー**: JavaScript からの呼び出し

**処理フロー**:
1. `MetadataUpdater.GetCapabilities()` を呼び出して機能サポートを確認
2. 初期状態の `StaticMethod1()` を呼び出し "OLD STRING" を確認
3. `ApplyUpdate()` で最初のデルタを適用
4. `StaticMethod1()` を呼び出し "NEW STRING" を確認
5. `ApplyUpdate()` で2番目のデルタを適用
6. `StaticMethod1()` を呼び出し "NEWEST STRING" を確認
7. すべて成功なら 42 を返却、いずれかで失敗なら 1 を返却

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースとの連携を行いません。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| MSG-001 | ログ出力 | "ret: {ret}" | TestMeaning 実行後 |
| MSG-002 | ログ出力 | "WASM EXIT {exit_code}" | テスト完了時 |
| MSG-003 | ログ出力 | "WASM ERROR {err}" | エラー発生時 |
| MSG-004 | ログ出力 | "Apply Delta Update for {basename}, revision {count}" | デルタ適用時 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| JavaScript Error | .NET ランタイム初期化失敗 | コンソールに "WASM ERROR" を出力 |
| 機能未サポート | MetadataUpdater.GetCapabilities() が null/empty | 終了コード 1 を返却 |
| 検証失敗 | StaticMethod1() の戻り値が期待値と異なる | 終了コード 1 を返却 |

## 備考

- 本画面は `.NET Runtime` リポジトリの機能テストであり、WebAssembly 環境でのホットリロード機能を検証する目的で作成されています。
- `DOTNET_MODIFIABLE_ASSEMBLIES=debug` 環境変数により、ホットリロード機能が有効化されます。
- テスト結果 42 は「生命、宇宙、そして万物についての究極の疑問の答え」（銀河ヒッチハイク・ガイド）の引用です。
- デルタファイル（.dmeta, .dil）はビルド時に生成され、実行時に File.ReadAllBytes() で読み込まれます。
- `tests_done` ラベルはテストランナーがテスト完了を検出するために使用されます。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ホットリロードで更新されるアセンブリの構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MethodBody1.cs | `src/tests/FunctionalTests/WebAssembly/Browser/HotReload/ApplyUpdateReferencedAssembly/MethodBody1.cs` | 更新対象のメソッド（初期状態） |
| 1-2 | MethodBody1_v1.cs | `src/tests/FunctionalTests/WebAssembly/Browser/HotReload/ApplyUpdateReferencedAssembly/MethodBody1_v1.cs` | 1回目の更新後の状態 |
| 1-3 | MethodBody1_v2.cs | `src/tests/FunctionalTests/WebAssembly/Browser/HotReload/ApplyUpdateReferencedAssembly/MethodBody1_v2.cs` | 2回目の更新後の状態 |

**読解のコツ**: `StaticMethod1()` の戻り値が "OLD STRING" → "NEW STRING" → "NEWEST STRING" と変化することを確認します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `src/tests/FunctionalTests/WebAssembly/Browser/HotReload/index.html` | HTML 構造と main.js の読み込み（1-18行目） |
| 2-2 | main.js | `src/tests/FunctionalTests/WebAssembly/Browser/HotReload/main.js` | .NET ランタイム初期化と TestMeaning 呼び出し（1-28行目） |

**主要処理フロー**:
1. **index.html 11行目**: `<script type='module' src="./main.js">` で main.js を読み込み
2. **main.js 13-16行目**: dotnet の初期化とホットリロード設定
3. **main.js 18-21行目**: TestMeaning メソッドの呼び出しと結果表示

#### Step 3: テストロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Program.cs | `src/tests/FunctionalTests/WebAssembly/Browser/HotReload/Program.cs` | TestMeaning メソッドの実装（1-82行目） |

**主要処理フロー**:
- **18-19行目**: `[JSExport]` 属性で JavaScript から呼び出し可能に
- **24-30行目**: MetadataUpdater.GetCapabilities() の検証
- **35-39行目**: 初期状態の検証 ("OLD STRING")
- **41-45行目**: 1回目の更新と検証 ("NEW STRING")
- **47-51行目**: 2回目の更新と検証 ("NEWEST STRING")
- **58-79行目**: ApplyUpdate メソッドでデルタファイルを適用

### プログラム呼び出し階層図

```
index.html
    │
    └─ main.js (type="module")
           │
           ├─ import { dotnet } from './_framework/dotnet.js'
           │
           ├─ dotnet.withConfig()
           │      └─ .withEnvironmentVariable("DOTNET_MODIFIABLE_ASSEMBLIES", "debug")
           │
           ├─ dotnet.create()
           │      └─ [.NET ランタイム初期化]
           │
           ├─ getAssemblyExports("WebAssembly.Browser.HotReload.Test.dll")
           │
           └─ exports.Sample.Test.TestMeaning()
                  │
                  ├─ MetadataUpdater.GetCapabilities()
                  │
                  ├─ MethodBody1.StaticMethod1() → "OLD STRING"
                  │
                  ├─ ApplyUpdate(assm) [1回目]
                  │      └─ MetadataUpdater.ApplyUpdate(dmeta, dil, dpdb)
                  │
                  ├─ MethodBody1.StaticMethod1() → "NEW STRING"
                  │
                  ├─ ApplyUpdate(assm) [2回目]
                  │      └─ MetadataUpdater.ApplyUpdate(dmeta, dil, dpdb)
                  │
                  └─ MethodBody1.StaticMethod1() → "NEWEST STRING"
                         │
                         └─ return 42 (success) or 1 (failure)
```

### データフロー図

```
[入力]                    [処理]                        [出力]

デルタファイル
  ├─ .dmeta ────────────▶
  └─ .dil ───────────────▶ ApplyUpdate()
                                │
                                ▼
                         MetadataUpdater.ApplyUpdate()
                                │
                                ▼
                         StaticMethod1() の動作変更
                                │
                                ▼
                         戻り値検証 ─────────────────▶ 結果表示
                         ("OLD"→"NEW"→"NEWEST")         span#out: 42
                                                        │
                                                        ▼
                                                   label#tests_done: 42
                                                        │
                                                        ▼
                                                   console: "WASM EXIT 42"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `src/tests/FunctionalTests/WebAssembly/Browser/HotReload/index.html` | テンプレート | テストページの HTML |
| main.js | `src/tests/FunctionalTests/WebAssembly/Browser/HotReload/main.js` | ソース | JavaScript エントリーポイント |
| Program.cs | `src/tests/FunctionalTests/WebAssembly/Browser/HotReload/Program.cs` | ソース | テストロジック（TestMeaning） |
| MethodBody1.cs | `src/tests/FunctionalTests/WebAssembly/Browser/HotReload/ApplyUpdateReferencedAssembly/MethodBody1.cs` | ソース | 更新対象アセンブリ（初期） |
| MethodBody1_v1.cs | `src/tests/FunctionalTests/WebAssembly/Browser/HotReload/ApplyUpdateReferencedAssembly/MethodBody1_v1.cs` | ソース | 更新対象アセンブリ（v1） |
| MethodBody1_v2.cs | `src/tests/FunctionalTests/WebAssembly/Browser/HotReload/ApplyUpdateReferencedAssembly/MethodBody1_v2.cs` | ソース | 更新対象アセンブリ（v2） |
| deltascript.json | `src/tests/FunctionalTests/WebAssembly/Browser/HotReload/ApplyUpdateReferencedAssembly/deltascript.json` | 設定 | デルタ生成設定 |
| WebAssembly.Browser.HotReload.Test.csproj | `src/tests/FunctionalTests/WebAssembly/Browser/HotReload/WebAssembly.Browser.HotReload.Test.csproj` | 設定 | プロジェクト設定 |
